'*******************************************************************************
' 
' Copyright 2008 Hewlett-Packard Development Company, L.P.
'
'Disclaimer Of Warranty and Support
'THE SOFTWARE AND ANY RELATED DOCUMENTATION ARE PROVIDED "AS IS", WITHOUT 
'WARRANTY OR SUPPORT OF ANY KIND.  THE ENTIRE RISK AS TO THE USE, RESULTS AND 
'PERFORMANCE OF THE SOFTWARE AND DOCUMENTATION ARE ASSUMED BY YOU AND THOSE TO 
'WHOM YOU PROVIDE THE SOFTWARE AND DOCUMENTATION.  HEWLETT-PACKARD COMPANY, 
'HEWLETT-PACKARD DEVELOPMENT COMPANY, AND THEIR AFFILIATES AND SUBSIDIARIARIES 
'HEREBY SPECIFICALLY DISCLAIM ANY AND ALL WARRANTIES, EXPRESS, IMPLIED OR 
'STATUTORY, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
'MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NONINFRINGEMENT.
'
'Limitation Of Liability
'IN NO EVENT SHALL HEWLETT-PACKARD COMPANY, HEWLETT-PACKARD DEVELOPMENT COMPANY 
'OR THEIR AFFILIATES AND SUBSIDIARIARIES BE LIABLE FOR ANY CLAIM, DAMAGES 
'(DIRECT, INDIRECT, INCIDENTAL, PUNITIVE, SPECIAL OR OTHER DAMAGES, INCLUDING 
'WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS INTERRUPTION, 
'LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY LOSS AND THE LIKE) OR OTHER 
'LIABILITY WHATSOEVER, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
'ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR DOCUMENTATION, EVEN 
'IF ADVISED OF THE POSSIBILITY OF SUCH CLAIM, DAMAGES OR OTHER LIABILITY. 
'
'
'*11-06-14 bab******************************************************************

option explicit

'
' Debugging trace flags, to enable debug output trace message
' change gDebugFlag to true.
'
const kDebugTrace = 1
const kDebugError = 2
dim   gDebugFlag

gDebugFlag = false

'
' Operation action values.
'
const kActionUnknown           = 0
const kActionLocation          = 1
const kActionReplace           = 2
const kActionExecute           = 4
const kActionVerbose           = 8

const kErrorSuccess            = 0
const KErrorFailure            = 1

const kNameSpace               = "root\cimv2"

'
' Generic strings
'
const L_Empty_Text                 = ""
const L_Space_Text                 = " "
const L_Comma_Text                 = " ,"
const L_Error_Text                 = "Error"
const L_Success_Text               = "Success"
const L_Failed_Text                = "Failed"
const L_Hex_Text                   = "0x"
const L_Printer_Text               = "Printer"
const L_Operation_Text             = "Operation"
const L_Provider_Text              = "Provider"
const L_Description_Text           = "Description"
const L_Debug_Text                 = "Debug:"

'
' Messages to be displayed if the scripting host is not cscript
'                            
const L_Help_Help_Host01_Text      = "Please run this script using CScript."  
const L_Help_Help_Host02_Text      = "This can be achieved by"
const L_Help_Help_Host03_Text      = "1. Using ""CScript script.vbs arguments"" or" 
const L_Help_Help_Host04_Text      = "2. Changing the default Windows Scripting Host to CScript"
const L_Help_Help_Host05_Text      = "   using ""CScript //H:CScript //S"" and running the script "
const L_Help_Help_Host06_Text      = "   ""script.vbs arguments""."

'
' General error messages
'                                                 
const L_Text_Error_General01_Text  = "The scripting host could not be determined."                
const L_Text_Error_General02_Text  = "Unable to parse command line." 
const L_Text_Error_General03_Text  = "Win32 error code"

'
' Miscellaneous messages
'
const L_Text_Msg_General09_Text    = "Number of printers enumerated"
const L_Text_Msg_General10_Text    = "Unable to connect to WMI server"    
const L_Text_Msg_General11_Text    = "Unable to enumarate printers"

'
' Debug messages
'
const L_Text_Dbg_Msg05_Text        = "In function ListPrinters"
const L_Text_Dbg_Msg08_Text        = "In function ParseCommandLine"

main

'
' Main execution starts here
'
sub main

    dim iAction
    dim iRetval
    dim strServer
    
    '
    ' Abort if the host is not cscript
    '
    if not IsHostCscript() then
   
        call wscript.echo(L_Help_Help_Host01_Text & vbCRLF & L_Help_Help_Host02_Text & vbCRLF & _
                          L_Help_Help_Host03_Text & vbCRLF & L_Help_Help_Host04_Text & vbCRLF & _
                          L_Help_Help_Host05_Text & vbCRLF & L_Help_Help_Host06_Text & vbCRLF)
        
        wscript.quit
   
    end if

    '
    ' Get command line parameters
    '
    iRetval = ParseCommandLine(iAction, strServer)

    if iRetval = kErrorSuccess then

        if (strServer = "") then
               strServer = "."
        end if

        iRetval = ListPrinters(iAction, strServer)

    end if

end sub

'
' List the printers
'
function ListPrinters(iAction, strServer)

'    on error resume next
    
    DebugPrint kDebugTrace, L_Text_Dbg_Msg05_Text

const HKCU = &H80000001
const HKLM = &H80000002

    dim oMaster
    dim oPrinter
    dim iTotal

    dim iResult
    dim strPort
    dim strResult 

    dim strLocation		
    dim strComment		
    dim strKeyPath
    dim strKeyRoot
    dim strValue
    dim strTemp
    dim oReg
    dim strPrinterName
    dim pos
    dim skip

    iResult = kErrorFailure

    wscript.echo "rem AddModelToCOmments.vbs version 09/12/04.1"

    if not CheckForPrnAdmin() then
        exit function
    end if

    set oMaster = CreateObject("PrintMaster.PrintMaster.1")
    if Err.Number <> kErrorSuccess then         
        wscript.echo "Unable to create Printmaster Object 0x" & hex(Err.Number) & "  " & Err.Description
        ListPrinters = kErrorFailure
        exit function
    end if    

    Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" &_
        strServer & "\root\default:StdRegProv")

    if Err.Number <> kErrorSuccess then         
        wscript.echo "Unable to create registry object 0x" & hex(Err.Number) & "  " & Err.Description
        ListPrinters = kErrorFailure
        exit function
    end if    

    if IsCluster(strServer) then
       strKeyRoot = GetModelPathFromCluster(oReg, strServer) & "\"
    else
       strKeyRoot = "SYSTEM\CurrentControlSet\Control\Print\Printers\"
    end if

    iTotal = 0

                   
' Loop through all the printers
'
    if strServer = "." then 
       strTemp = ""
    else
       strTemp = "\\" & strServer
    end if

    for each oPrinter in oMaster.Printers(strTemp)
    
        iTotal = iTotal + 1 
        skip   = false  

        if (iAction AND kActionVerbose) then
            wscript.echo "rem Printer Name: " & oPrinter.PrinterName & "   Driver Name: " & oPrinter.DriverName                    
        end if

		if InStr (oPrinter.DriverName, "HP Universal Printing") then

' Read from bidicache in HKLM\...\printerdriverdata\BidiCache

'           Need to remove the servername from the printer name.
            pos = InStrRev(oPrinter.PrinterName, "\")
            strPrinterName = mid ( oPrinter.PrinterName, pos+1)
    	    strKeyPath = StrKeyRoot & strPrinterName & "\PrinterDriverData\BidiCache"

'            WScript.Echo "rem strKeyPath: " & strKeyPath

			oReg.GetStringValue HKLM, strKeyPath, "MODEL_NAME", strValue

' Check to see if the model name is already there.  If so, then skip

			if InStr (oPrinter.Comment, strValue) > 0 then
                skip = true
            end if

			if (iAction AND kActionLocation) AND InStr (oPrinter.Location, strValue) > 0 then
                skip = true
            end if

' Check to see if the model string is empty.
			'Server 2008 R2 with UPD 5.3 puts one space character in the registry, so len could be 1
			if len (strValue & "") < 2 then   ' hack to convert strValue to variant of type string
                skip = true
                wscript.echo "REM Empty Model information for Printer: " & strPrinterName 
            end if

            if (skip = false) then

               if (iAction AND kActionReplace) then
				  strComment  = strValue
                  strLocation = strValue 
               else
                  strComment  = oPrinter.Comment  & " (" & strValue & ")"
       	          strLocation = oPrinter.Location & " (" & strValue & ")" 
               end if
 
' Format the printui.dll command
'//            rundll32 printui.dll,PrintUIEntry /Xs /n "printer" comment "My Cool Printer"

			   strResult = "rundll32 printui.dll,PrintUIEntry /Xs /n "
			   if strServer = "." then
					strResult = strResult & chr(34) & strPrinterName & chr(34) & L_Space_Text
			   else 
					strResult = strResult & chr(34) & "\\" & strServer & "\" & strPrinterName & chr(34) & L_Space_Text
			   end if         
               if (iAction AND kActionLocation) then
                  strResult = strResult & "location " & chr(34) & strLocation & chr(34) 
                  if (iAction AND kActionExecute) then
                     oPrinter.Location = strLocation
                     oPrinter.Put_
                  end if
               else
                  strResult = strResult & "comment " & chr(34) & strComment & chr(34) 
                  if (iAction AND kActionExecute) then
                     oPrinter.Comment = strComment
                     oPrinter.Put_
                  end if
               end if

               wscript.echo strResult

		   end if

	end if

        Err.Clear
        
    next

    wscript.echo L_Empty_Text
    wscript.echo "rem " & L_Text_Msg_General09_Text & L_Space_Text & iTotal 
    
    ListPrinters = kErrorSuccess

end function


'
' Get the Cluster registry path to the Model name
'
function GetModelPathFromCluster(oReg, strComputer)

'    on error resume next

const HKLM = &H80000002    

    dim strKeyPath
    dim strResKeyPath
    dim strResource
    dim subkey
    dim arrSubKeys
    dim strName
    dim strName2
    dim strType
    dim Result
    dim arrResources
	
    GetModelPathFromCluster = ""

    strKeyPath    = "Cluster\Groups\" 
    strResKeyPath = "Cluster\Resources\" 

    Err.Clear	
    Result = oReg.EnumKey(HKLM, strKeyPath, arrSubKeys)

    If (Result <> 0) OR (Err.Number <> 0) Then   
        wscript.echo "EnumKey Error: " & hex(Err.Number) & "  " & Err.Description
        exit function
    end if    

    For Each subkey In arrSubKeys
       oReg.GetStringValue HKLM, strKeyPath & subkey, "Name", strName

'       if (StrComp (strName, strComputer, 1) = 0) then
       if (InStr(1,strName, strComputer, 1) > 0) then
'          WScript.Echo "rem Subkey: " & subkey & "  " & strName

          Result = oReg.GetMultiStringValue(HKLM, strKeyPath & subkey, "Contains" , arrResources)

          If (Result = 0) And (Err.Number = 0) Then   

             For Each strResource In arrResources

                oReg.GetStringValue HKLM, strResKeyPath & strResource, "Type", strType

                If (Result = 0) And (Err.Number = 0) Then   
                   if (strType = "Print Spooler") then
'                      WScript.Echo "rem Resource: " & strResource & "  " & strType
                      GetModelPathFromCluster = strResKeyPath & strResource & "\Parameters\Printers"
                   end if
                else    
                   wscript.echo "EnumKey Error: " & hex(Err.Number) & "  " & Err.Description
                   exit function
                end if    

             Next

          Else
             Wscript.Echo "GetMultiStringValue failed. Error = " & Err.Number 
             exit function
          End If

       end if

    Next

end function


function IsCluster(strComputer)

    On Error Resume Next

    dim objWMIService
    dim colItems		
    dim objItem
    dim strPNodeName

    IsCluster = false

    Set objWMIService = GetObject("winmgmts:" _
        & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\mscluster")

    Set colItems = objWMIService.ExecQuery("Select * from MSCluster_Node")

    For Each objItem in colItems

        strPNodeName = objItem.Name    

        if Err <> 0 then
            Wscript.Echo "rem not a cluster server"
        else
            if StrComp(strPNodeName, strComputer, 1) = 0 then
                Wscript.Echo "rem This is a physical node"
            else
                Wscript.Echo "rem This is a virtual node"
                IsCluster = true
            end if
        end if
    Next
    Set objWMIService = nothing
    Set colItems = nothing
	
end function


'
' Debug display helper function
'
sub DebugPrint(uFlags, strString)

    if gDebugFlag = true then

        if uFlags = kDebugTrace then

            wscript.echo L_Debug_Text & L_Space_Text & strString

        end if

        if uFlags = kDebugError then

            if Err <> 0 then

                wscript.echo L_Debug_Text & L_Space_Text & strString & L_Space_Text _
                             & L_Error_Text & L_Space_Text & L_Hex_Text & hex(Err.Number) _
                             & L_Space_Text & Err.Description

            end if

        end if

    end if

end sub

'
' Parse the command line into its components
'
function ParseCommandLine(iAction, strServer)

    on error resume next    

    DebugPrint kDebugTrace, L_Text_Dbg_Msg08_Text

    dim oArgs
    dim iIndex

    iAction = kActionUnknown
    iIndex  = 0

    set oArgs = wscript.Arguments

    while iIndex < oArgs.Count

        select case oArgs(iIndex)

            case "-l"
                iAction = iAction + kActionLocation
                
            case "-s"
                iIndex = iIndex + 1
                strServer = RemoveBackslashes(oArgs(iIndex))

            case "-r"
                iAction = iAction + kActionReplace

            case "-v"
                iAction = iAction + kActionVerbose
            
            case "-x"
                iAction = iAction + kActionExecute
            
            case "-?"
                Usage(true)
                exit function

            case else
                Usage(true)
                exit function

        end select

        iIndex = iIndex + 1

    wend    

    if Err = kErrorSuccess then

        ParseCommandLine = kErrorSuccess

    else
    
        wscript.echo L_Text_Error_General02_Text & L_Space_Text & L_Error_Text & L_Space_Text _
                     & L_Hex_Text & hex(Err.Number) & L_Space_text & Err.Description
        
        ParseCommandLine = kErrorFailure        

    end if    
    
end  function

'
' Display command usage.
'
sub Usage(bExit)

    wscript.echo "Usage: AddModelToComments [-l?] [-s server]"
    wscript.echo " "               
    wscript.echo "Arguments:"
    wscript.echo "-l     - put model in location field instead of comments field"
    wscript.echo "-r     - replace contents instead of concatenate"
    wscript.echo "-s     - cluster or remote server name"
    wscript.echo "-v     - verbose mode - list all printers and drivers found"
    wscript.echo "-x     - execute now instead of creating batch file"
    wscript.echo "-?     - display command usage"
    wscript.echo "Examples:"
    wscript.echo "AddModelToComments -l -r -s server_name"

    if bExit then
    
        wscript.quit(1)
        
    end if

end sub

'
' Determines which program is being used to run this script. 
' Returns true if the script host is cscript.exe
'
function IsHostCscript()

    on error resume next
    
    dim strFullName 
    dim strCommand 
    dim i, j 
    dim bReturn
    
    bReturn = false
    
    strFullName = WScript.FullName
    
    i = InStr(1, strFullName, ".exe", 1)
    
    if i <> 0 then
        
        j = InStrRev(strFullName, "\", i, 1)
        
        if j <> 0 then
            
            strCommand = Mid(strFullName, j+1, i-j-1)
            
            if LCase(strCommand) = "cscript" then
            
                bReturn = true  
            
            end if    
                
        end if
        
    end if
    
    if Err <> 0 then
    
        wscript.echo L_Text_Error_General01_Text & L_Space_Text & L_Error_Text & L_Space_Text _
                     & L_Hex_Text & hex(Err.Number) & L_Space_Text & Err.Description 
        
    end if
    
    IsHostCscript = bReturn

end function

'
' Retrieves extended information about the last error that occured 
' during a WBEM operation. The methods that set an SWbemLastError
' object are GetObject, PutInstance, DeleteInstance
'
sub LastError()

    on error resume next

    dim oError

    set oError = CreateObject("WbemScripting.SWbemLastError")
   
    if Err = kErrorSuccess then
   
        wscript.echo L_Operation_Text            & L_Space_Text & oError.Operation
        wscript.echo L_Provider_Text             & L_Space_Text & oError.ProviderName
        wscript.echo L_Description_Text          & L_Space_Text & oError.Description
        wscript.echo L_Text_Error_General03_Text & L_Space_Text & oError.StatusCode
                
    end if                                                             
                                                             
end sub


'
' Remove leading "\\" from server name
'
function RemoveBackslashes(strServer)

    dim strRet
    
    strRet = strServer
    
    if Left(strServer, 2) = "\\" and Len(strServer) > 2 then 
   
        strRet = Mid(strServer, 3) 
        
    end if   

    RemoveBackslashes = strRet

end function

'
' Check for printadmin.dll
'
function CheckForPrnAdmin()

    on error resume next

    dim oMaster
    dim WshShell

    CheckForPrnAdmin = true

    set oMaster = CreateObject("PrintMaster.PrintMaster.1")
    If Err <> 0 then

         Err.Clear

         Set WshShell = wscript.CreateObject("Wscript.Shell")
         WshShell.Run "regsvr32 /s prnadmin.dll",0,TRUE

         set oMaster = CreateObject("PrintMaster.PrintMaster.1")
         If Err <> 0 then
              wscript.echo Err.number & "  " & Err.Description
              wscript.echo "Failed to register prnadmin.dll"
              wscript.exho "Download and install the Windows Server 2003 Resource Kit"
              CheckForPrnAdmin = false
         end if
    end if

    Set oMaster  = nothing
    Set WshShell = nothing

end function


'' SIG '' Begin signature block
'' SIG '' MIIZSgYJKoZIhvcNAQcCoIIZOzCCGTcCAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFK4UGgoB3vVv
'' SIG '' ikCm06B16FgOTWUxoIIURDCCA+4wggNXoAMCAQICEH6T
'' SIG '' 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
'' SIG '' CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
'' SIG '' cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
'' SIG '' EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
'' SIG '' Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
'' SIG '' aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
'' SIG '' NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
'' SIG '' bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
'' SIG '' bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
'' SIG '' RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
'' SIG '' AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
'' SIG '' FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
'' SIG '' a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
'' SIG '' AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
'' SIG '' +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
'' SIG '' 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
'' SIG '' 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
'' SIG '' RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
'' SIG '' gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
'' SIG '' gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
'' SIG '' aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
'' SIG '' CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
'' SIG '' Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
'' SIG '' bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
'' SIG '' VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
'' SIG '' VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
'' SIG '' BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
'' SIG '' nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
'' SIG '' sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
'' SIG '' JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
'' SIG '' g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
'' SIG '' UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
'' SIG '' MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
'' SIG '' BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
'' SIG '' dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
'' SIG '' MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
'' SIG '' VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
'' SIG '' AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
'' SIG '' cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
'' SIG '' sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
'' SIG '' duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
'' SIG '' TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
'' SIG '' YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
'' SIG '' vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
'' SIG '' nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
'' SIG '' 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
'' SIG '' EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
'' SIG '' FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
'' SIG '' AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
'' SIG '' MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
'' SIG '' bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
'' SIG '' MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
'' SIG '' ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
'' SIG '' MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
'' SIG '' VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
'' SIG '' IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
'' SIG '' SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
'' SIG '' st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
'' SIG '' JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
'' SIG '' dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
'' SIG '' bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
'' SIG '' K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
'' SIG '' SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
'' SIG '' ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
'' SIG '' w7wc2AR1MIIFmTCCBIGgAwIBAgIQek15SwtA1sKF5Kuj
'' SIG '' /CAmrDANBgkqhkiG9w0BAQUFADCBtDELMAkGA1UEBhMC
'' SIG '' VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
'' SIG '' VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYD
'' SIG '' VQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cu
'' SIG '' dmVyaXNpZ24uY29tL3JwYSAoYykxMDEuMCwGA1UEAxMl
'' SIG '' VmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNpZ25pbmcgMjAx
'' SIG '' MCBDQTAeFw0xMTA1MTcwMDAwMDBaFw0xNDA1MTYyMzU5
'' SIG '' NTlaMIHcMQswCQYDVQQGEwJVUzEWMBQGA1UECBMNTWFz
'' SIG '' c2FjaHVzZXR0czEQMA4GA1UEBxMHQW5kb3ZlcjEgMB4G
'' SIG '' A1UEChQXSGV3bGV0dC1QYWNrYXJkIENvbXBhbnkxPjA8
'' SIG '' BgNVBAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAtIE1pY3Jv
'' SIG '' c29mdCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYyMR8wHQYD
'' SIG '' VQQLFBZQcm9kdWN0IERldmVsb3BtZW50IElUMSAwHgYD
'' SIG '' VQQDFBdIZXdsZXR0LVBhY2thcmQgQ29tcGFueTCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIzhXP/p
'' SIG '' 063Ocr3wzFPp9UANDoViFY5rgfoZXMGJUIZ/b2vZB2EE
'' SIG '' rVRY83dS1EewWcdV1/UUF179CPmy1sVD+6wtiE1E4xFH
'' SIG '' O47aLykpFa1wEi7/KlXqOaabILE9c12J4Lgydk8a5XBC
'' SIG '' rcZtY3wjKlTInz+fiSCu5+SNQx7yzEa0VELkUx0noTb1
'' SIG '' nxnxxY0FYdHzUDVnFcOE6LiIA+KFBS6P6LqrunoS27bI
'' SIG '' cSQJfqI700a6okgqZZJFryIIz1ZBhbkZ+ZMtUGB1kCy9
'' SIG '' p2W9KWyt9mkKiKgiEZ4acmgb8dhStBhS4pfvdTbC5EhH
'' SIG '' 02tYRNjFUmOvbGHYISLmIkFPy+sCAwEAAaOCAXswggF3
'' SIG '' MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMEAGA1Ud
'' SIG '' HwQ5MDcwNaAzoDGGL2h0dHA6Ly9jc2MzLTIwMTAtY3Js
'' SIG '' LnZlcmlzaWduLmNvbS9DU0MzLTIwMTAuY3JsMEQGA1Ud
'' SIG '' IAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggrBgEFBQcC
'' SIG '' ARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYTAT
'' SIG '' BgNVHSUEDDAKBggrBgEFBQcDAzBxBggrBgEFBQcBAQRl
'' SIG '' MGMwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlz
'' SIG '' aWduLmNvbTA7BggrBgEFBQcwAoYvaHR0cDovL2NzYzMt
'' SIG '' MjAxMC1haWEudmVyaXNpZ24uY29tL0NTQzMtMjAxMC5j
'' SIG '' ZXIwHwYDVR0jBBgwFoAUz5mp6nsm9EvJjo/X8AUm7+PS
'' SIG '' p50wEQYJYIZIAYb4QgEBBAQDAgQQMBYGCisGAQQBgjcC
'' SIG '' ARsECDAGAQEAAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQB2
'' SIG '' cD+Z75mvL+z+4bmyxasX3jLTFruETIeDiHFHVvT01BRY
'' SIG '' TM3NhI1DAtrmYsEsF63+91ajbS5ebSoyXZhJUl/VMnrk
'' SIG '' FrAVeLAANyRyuHiLuaJK9F1jIW+H9oPKmUwxkCoIfH9f
'' SIG '' xYYwlCJX6ec3ceTCfwTbVWCxSIR0Xq9SKMS6geocAaFG
'' SIG '' uQSVLX/qAbmjvDQwvPs+GlACKrebTkspzG3lXaMBkC5K
'' SIG '' xd31zwm7S5TxV2g6y71iScH1igwxJhTFa3AoeyMf/9M2
'' SIG '' fiNWmbnTSf0Nw6XwVWSAF0m7nQOOiSlQPWAUwNKU2e3E
'' SIG '' p+eJOGBTh1fBe0tAm4C7PPaY2dVYqcATMIIGCjCCBPKg
'' SIG '' AwIBAgIQUgDlqiVW/BqG7ZbJ1EszxzANBgkqhkiG9w0B
'' SIG '' AQUFADCByjELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZl
'' SIG '' cmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2lnbiBU
'' SIG '' cnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwNiBW
'' SIG '' ZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVz
'' SIG '' ZSBvbmx5MUUwQwYDVQQDEzxWZXJpU2lnbiBDbGFzcyAz
'' SIG '' IFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0
'' SIG '' aG9yaXR5IC0gRzUwHhcNMTAwMjA4MDAwMDAwWhcNMjAw
'' SIG '' MjA3MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNV
'' SIG '' BAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJp
'' SIG '' U2lnbiBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJt
'' SIG '' cyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24u
'' SIG '' Y29tL3JwYSAoYykxMDEuMCwGA1UEAxMlVmVyaVNpZ24g
'' SIG '' Q2xhc3MgMyBDb2RlIFNpZ25pbmcgMjAxMCBDQTCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPUjS16l
'' SIG '' 14q7MunUV/fv5Mcmfq0ZmP6onX2U9jZrENd1gTB/BGh/
'' SIG '' yyt1Hs0dCIzfaZSnN6Oce4DgmeHuN01fzjsU7obU0PUn
'' SIG '' NbwlCzinjGOdF6MIpauw+81qYoJM1SHaG9nx44Q7iipP
'' SIG '' hVuQAU/Jp3YQfycDfL6ufn3B3fkFvBtInGnnwKQ8PEEA
'' SIG '' Pt+W5cXklHHWVQHHACZKQDy1oSapDKdtgI6QJXvPvz8c
'' SIG '' 6y+W+uWHd8a1VrJ6O1QwUxvfYjT/HtH0WpMoheVMF05+
'' SIG '' W/2kk5l/383vpHXv7xX2R+f4GXLYLjQaprSnTH69u08M
'' SIG '' PVfxMNamNo7WgHbXGS6lzX40LYkCAwEAAaOCAf4wggH6
'' SIG '' MBIGA1UdEwEB/wQIMAYBAf8CAQAwcAYDVR0gBGkwZzBl
'' SIG '' BgtghkgBhvhFAQcXAzBWMCgGCCsGAQUFBwIBFhxodHRw
'' SIG '' czovL3d3dy52ZXJpc2lnbi5jb20vY3BzMCoGCCsGAQUF
'' SIG '' BwICMB4aHGh0dHBzOi8vd3d3LnZlcmlzaWduLmNvbS9y
'' SIG '' cGEwDgYDVR0PAQH/BAQDAgEGMG0GCCsGAQUFBwEMBGEw
'' SIG '' X6FdoFswWTBXMFUWCWltYWdlL2dpZjAhMB8wBwYFKw4D
'' SIG '' AhoEFI/l0xqGrI2Oa8PPgGrUSBgsexkuMCUWI2h0dHA6
'' SIG '' Ly9sb2dvLnZlcmlzaWduLmNvbS92c2xvZ28uZ2lmMDQG
'' SIG '' A1UdHwQtMCswKaAnoCWGI2h0dHA6Ly9jcmwudmVyaXNp
'' SIG '' Z24uY29tL3BjYTMtZzUuY3JsMDQGCCsGAQUFBwEBBCgw
'' SIG '' JjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNp
'' SIG '' Z24uY29tMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
'' SIG '' BQcDAzAoBgNVHREEITAfpB0wGzEZMBcGA1UEAxMQVmVy
'' SIG '' aVNpZ25NUEtJLTItODAdBgNVHQ4EFgQUz5mp6nsm9EvJ
'' SIG '' jo/X8AUm7+PSp50wHwYDVR0jBBgwFoAUf9Nlp8Ld7Lvw
'' SIG '' MAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQEFBQADggEBAFYi
'' SIG '' 5jSkxGHLSLkBrVaoZA/ZjJHEu8wM5a16oCJ/30c4Si1s
'' SIG '' 0X9xGnzscKmx8E/kDwxT+hVe/nSYSSSFgSYckRRHsExj
'' SIG '' jLuhNNTGRegNhSZzA9CpjGRt3HGS5kUFYBVZUTn8WBRr
'' SIG '' /tSk7XlrCAxBcuc3IgYJviPpP0SaHulhncyxkFz8PdKN
'' SIG '' rEI9ZTbUtD1AKI+bEM8jJsxLIMuQH12MTDTKPNjlN9Zv
'' SIG '' pSC9NOsm2a4N58Wa96G0IZEzb4boWLslfHQOWP51G2M/
'' SIG '' zjF8m48blp7FU3aEW5ytkfqs7ZO6XcghU8KCU2OvEg1Q
'' SIG '' hxEbPVRSloosnD2SGgiaBS7Hk6VIkdMxggRyMIIEbgIB
'' SIG '' ATCByTCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZl
'' SIG '' cmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2lnbiBU
'' SIG '' cnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1
'' SIG '' c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29tL3Jw
'' SIG '' YSAoYykxMDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xhc3Mg
'' SIG '' MyBDb2RlIFNpZ25pbmcgMjAxMCBDQQIQek15SwtA1sKF
'' SIG '' 5Kuj/CAmrDAJBgUrDgMCGgUAoHAwEAYKKwYBBAGCNwIB
'' SIG '' DDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQw
'' SIG '' HAYKKwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJ
'' SIG '' KoZIhvcNAQkEMRYEFPVvo4oLHhSE5loWZQq1WiZWvu0i
'' SIG '' MA0GCSqGSIb3DQEBAQUABIIBAIJexUWTYEYBix8CyQg7
'' SIG '' J8b7XlV0xDHGO6RzoUp3gqhXMbvzBn8oMSz+asMGUMHa
'' SIG '' wmY/zrQSZgVn/aKFGBEM7dLVhwg1ymldagy2BrIAk9/I
'' SIG '' 5H9mrB+cFh1g3QRnU0JQEuE7Lrg6LQq3s1GgofVsoZ1R
'' SIG '' ly85IboYe2wF30X8xbRue1h8s8HB2Oo9NIn0gJnM7Lzv
'' SIG '' XiwlfLvn3XPVMUdnoHRO3f2RGiCVLB8wvt/mmsRU5KCk
'' SIG '' xOzwyTi+4uh1lDtgKV51yiocQKEHufPMXqiMfkGVSOat
'' SIG '' 5j7z3hiAvRBJ6to0oUzPzXfDUhahvJYGxCQei6p6A0wX
'' SIG '' 5IwMB5XXdxxIpAGhggILMIICBwYJKoZIhvcNAQkGMYIB
'' SIG '' +DCCAfQCAQEwcjBeMQswCQYDVQQGEwJVUzEdMBsGA1UE
'' SIG '' ChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAuBgNVBAMT
'' SIG '' J1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2VydmljZXMg
'' SIG '' Q0EgLSBHMgIQDs/0OMj+vzVuBNhqmBsaUDAJBgUrDgMC
'' SIG '' GgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAc
'' SIG '' BgkqhkiG9w0BCQUxDxcNMTMwMjIxMjMxOTA5WjAjBgkq
'' SIG '' hkiG9w0BCQQxFgQUn7KapQf1a/I/FwH6xyeWwxv6dKUw
'' SIG '' DQYJKoZIhvcNAQEBBQAEggEAHkWrfICaXMIBBt9SZT8x
'' SIG '' NrqNNCvSRxbrxOcZCQz+h0GOIcgRaFn/gXfsv4yO16VY
'' SIG '' a8WyRVZTSX4MFwQSwYWcK+4JsR8hzeeaDhUVWfFDwEyL
'' SIG '' bUWIgcy8tOc3+KL8ASjg1kYoDegn1gAwD2LMrBr0twNn
'' SIG '' RLBEFDqvkDO3lqvj+5HCgbwQar0+3p3yIl/YoLQ/GBJr
'' SIG '' axQWRVnJWoGc3rzuE0OsNGMKknRSelStoQzYhUtPZw/W
'' SIG '' L1WEdTR+y4bsNIqyxXTr6wScDOstxmgD2YpfOaQpofuP
'' SIG '' Aqpucy0N6QMy0MgYmbU7YDDN4yjI5Xab9TR1ZNk4UrAe
'' SIG '' x9/pEPcbRqZshw==
'' SIG '' End signature block
